-- **************************************************************
-- Script Name  	: C_36568_SetPaymentTermsAllNonsetClients.sql
-- Tracker job    	: 36568
-- Release Date	:  

-- ***************************************************************
-- Dependancies :
 
--	Viztopia 4.1930
--	Viztopia 4.19325
--  Viztopia 4.30
--  Viztopia 4.32
--  Viztopia 4.40

--	22964_CommonScriptLoggingSystem.sql

-- ***************************************************************
-- Description of issue and symptoms:
  
 
-- ***************************************************************
-- Brief description of what script does:
 -- Set payment terms on all clients - where payment terms have not already been set.

-- ***************************************************************
-- Script execution instructions:

-- 1. Backup data
-- 2. Pre-run tests:
-- 	* 
-- 3. Run script(s)
-- 4. Backup data
-- 5. Check the script log for details
-- 6. Post-run tests
--	*

-- ***************************************************************/

SET NOCOUNT ON
GO


-- Script name
DECLARE @ScriptName		AS VARCHAR(255)
SET @ScriptName			= 'C_36568_SetPaymentTermsAllNonsetClients.sql'

-- Core variables - for version checks 
DECLARE @Result			AS INT	
DECLARE @LogID			AS INT

DECLARE @SectionName		AS VARCHAR(255)
SET @SectionName		=''

DECLARE @TextToWrite		AS VARCHAR(4000)
SET @TextToWrite		= ''

DECLARE @VIZ31sp1		AS DECIMAL(6,4)
SET @VIZ31sp1			=3.102

DECLARE @VIZ32100		AS DECIMAL(6,4)
SET @VIZ32100			=3.21

DECLARE @VIZ32500		AS DECIMAL(6,4)
SET @VIZ32500			=3.25

DECLARE @VIZ40145		AS DECIMAL(6,4)
SET @VIZ40145			=4.0145

DECLARE @VIZ40147		AS DECIMAL(6,4)
SET @VIZ40147			=4.0147

DECLARE @VIZPRI41		AS DECIMAL(6,4)
SET @VIZPRI41			=4.1920

DECLARE @VIZPRI43		AS DECIMAL(6,4)
SET @VIZPRI43			=4.19999

DECLARE @VIZ41930		AS DECIMAL(6,4)
SET @VIZ41930			=4.1930

DECLARE @VIZ419325		AS DECIMAL(6,4)
SET @VIZ419325			=4.19325

DECLARE @VIZ43000		AS DECIMAL(6,4)
SET @VIZ43000			=4.3190

DECLARE @VIZ43218		AS DECIMAL(6,4)
SET @VIZ43218			=4.3218

DECLARE @VIZPRI44		AS DECIMAL(6,4)
SET @VIZPRI44			=4.3999

DECLARE @VIZPRI45		AS DECIMAL(6,4)
SET @VIZPRI45			=4.4999

DECLARE @VIZ__MAX		AS DECIMAL(6,4)
SET @VIZ__MAX			= @VIZPRI45

DECLARE @SQL_TRUE		AS INT
SET @SQL_TRUE			= 1

DECLARE @CrLf			AS VARCHAR(2)
SET @CrLf			= char(13) + char(10)

-- General constants used within script 

DECLARE @CountEntries		AS INT
SET @CountEntries		= 0

DECLARE @ErrorCode 		AS INT
SET @ErrorCode			= 0


-- General variables used within script 
DECLARE @TermsType			AS Varchar(50)
DECLARE @DefaultPeriod		AS INT
DECLARE @OverrideSettings	AS BIT
DECLARE @TreatPeriodAsBlank	AS INT

-- User configurable variables in script

-- Please set the following line to set the default period for clients

SET @TermsType = 'Month End Days'	-- Set this to the term type you want to use
SET @DefaultPeriod = 20				-- Set this to the payment period to use for clients
SET @OverrideSettings = 0			-- Set this to 0 - only set if blank, or 1 - overwrite all entries

SET @TreatPeriodAsBlank = 20		-- Set this to the payment period to ignore


-- Start of script execution 
EXEC @LogID = LogScriptHeader @ScriptName
IF @LogID>0
BEGIN
--	EXEC @Result = IsDatabaseVersionWithin @VIZPRI41, @VIZ__MAX	
--	IF @Result = @SQL_TRUE
--	BEGIN

		IF @OverrideSettings=0
		BEGIN

			UPDATE ClientSupplier
			SET TermsTypeID=TermsType.TermsTypeID
			,TermsDay=@DefaultPeriod
			FROM ClientSupplier CS
			CROSS JOIN TermsType
			WHERE TermsTypeDesc=@TermsType
			AND 
				((CS.TermsTypeID IS NULL	AND CS.TermsDay IS NULL) 
				 OR CS.TermsDay=@TreatPeriodAsBlank)
		END
		ELSE
		BEGIN
			UPDATE ClientSupplier
			SET TermsTypeID=TermsType.TermsTypeID
			,TermsDay=@DefaultPeriod
			FROM ClientSupplier CS
			CROSS JOIN TermsType
			WHERE
				TermsTypeDesc=@TermsType
		END

		SET @CountEntries=@@ROWCOUNT
		
		SET @TextToWrite='No. of clients with terms set to ' + CAST(@DefaultPeriod AS Varchar(10)) + ' ' + @TermsType + ' is ' + CAST(@CountEntries AS Varchar(10))
		EXEC LogScriptDetail @LogID, @SectionName, @TextToWrite	

--	END
--	ELSE
--		EXEC LogScriptError @LogID, 'Database version is outside of acceptable range for this script.'
		
	EXEC LogScriptFooter @LogID
END


GO

GO

